var max_explosions = 60;
var exp_max_frame = 6;
var g_exp_update = 2;
var exps = new Array();
for (i=0;i<max_explosions;i++)
	exps[i] = new Object();

function SetupExplosions()
{
  for (i=0;i<max_explosions;i++)
  {
		exps[i].x = -100;
		exps[i].y = 0;
		exps[i].vx = 0;
		exps[i].vy = 0;
		exps[i].type = 0;
		
		exps[i].frame = 0;
		exps[i].dir = "explode1";
		exps[i].name = "exp"+i;
		exps[i].id1 = GetPersonID("exp"+i);
		exps[i].layer = gut_layer+1;
		exps[i].scale = 1;
  }
}

var blast_radius = 32;
var blast_speed = 5;
var exp_owner_ratio = 0.25;

function SpawnExplosion(x,y, damage, owner, scale, type,vx,vy, invs, targetdsi)
{
	if (invs == undefined)
		invs = -1;
		
	if (type != 2 && type != 3 && invs == -1)
	{
		if (scale > 1)
			PlaySound(24);
		else
			PlaySound(27);
	}
	if (scale == undefined)
		scale = 1;
		
  var lengthx, lengthy, length;
  var flamedy = 1;
	//do damage from explosion
	
	
	for (dsi=0;dsi<max_entities;dsi++)
	{
		if (targetdsi != undefined)
			dsi = targetdsi;
		if (invs > -1)
		{
			dsi = invs;
			flamedy = 0;
		}
		if (type==2)
			break;
		if (entities[dsi].hp > 0 && (dsi != owner || dsi == 0) && entities[dsi].ambush == false && entities[dsi].nohit != true)
		{
		  lengthx = (entities[dsi].x-x);
		  lengthy = (entities[dsi].y-y);
			if (Math.sqrt(lengthx*lengthx + lengthy*lengthy) < blast_radius*scale || targetdsi!=undefined)
			{
				if (dsi == 0 && damage > 0)
				{
					if (!(entities[0].invince > 0 || entities[0].hp <= 0 || oblit_shield > 0))
					{
						if (dsi == owner)
						{
							if (Math.sqrt(lengthx*lengthx + lengthy*lengthy) < blast_radius*scale*0.5)
								RemovePlayerHP(exp_owner_ratio*damage);
						}
						else
							RemovePlayerHP(damage);
					}
				}
				else if (entities[dsi].type == 6)
				{
					//no damage, just change frame and direction.
					entities[dsi].dir2 = "injury2";
					entities[dsi].frame2 = 0;
				}
				else if (damage > 0)
				{
					entities[dsi].hp -= damage;
					//add in blood trails
					if (entity_misc[entities[dsi].type].blood == 1)
					{
						if (damage < 3)
						{
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),3, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),3, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),3, "");
						}
						else if (damage < 6)
						{
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),2, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),2, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),2, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*damage-damage/2,Math.random()*(-1*damage),2, "");
						}
						else 
						{
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*6-3,Math.random()*(-1*6),1, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*6-3,Math.random()*(-1*6),1, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*6-3,Math.random()*(-1*6),1, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*6-3,Math.random()*(-1*6),1, "");
						SpawnBlood(entities[dsi].x,entities[dsi].y,Math.random()*6-3,Math.random()*(-1*6),1, "");
						}
					}
				
					length = Math.sqrt(lengthx*lengthx + lengthy*lengthy);
					if (length != 0)
						entities[dsi].vx = blast_speed*lengthx/length;
					else
					{
						entities[dsi].vx = 0;
						length = 1;
					}
					//entities[dsi].vy = blast_speed*lengthy/length;
	
					if (entity_misc[entities[dsi].type].blood == 1)
						AddBackBlood(Math.floor(entities[dsi].x/GetTileWidth()),Math.floor(entities[dsi].y/GetTileHeight()),4);
					
					if (entities[dsi].hp <=0)
					{
						if (entity_misc[entities[dsi].type].blood == 1)
						{
							entities[dsi].hp = 0;
							
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[dsi].x/GetTileWidth()),Math.floor(entities[dsi].y/GetTileHeight()+1),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[dsi].x/GetTileWidth()),Math.floor(entities[dsi].y/GetTileHeight()-1),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[dsi].x/GetTileWidth()+1),Math.floor(entities[dsi].y/GetTileHeight()),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[dsi].x/GetTileWidth()-1),Math.floor(entities[dsi].y/GetTileHeight()),4);
						}
	



						if (entities[dsi].type != 2)
						{
							if (entities[dsi].type == 1)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
				
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp1 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp2 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp3 > 0)
								{
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									if (Math.random() < 0.5)
										SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
							}
							else if (entities[dsi].type == 3)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
				
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp1 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp2 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp3 > 0)
								{
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									if (Math.random() < 0.5)
										SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
							}
							else if (entities[dsi].type == 5)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
				
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "eye1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp1 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "eye1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp2 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "eye1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp3 > 0)
								{
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "eye1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									if (Math.random() < 0.5)
										SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "eye1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
							}
							else if (entities[dsi].type == 7)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
				
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "mantis_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp1 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "mantis_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp2 > 0)
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "mantis_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp3 > 0)
								{
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "mantis_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									if (Math.random() < 0.5)
										SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "mantis_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
							}
							else if (entities[dsi].type == 8)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
				
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "drone_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								if (entities[dsi].hp2 > 0)
								{
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "drone_legs1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "drone_legs1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "drone_legs1", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
							}
							else if (entities[dsi].type == 11)
							{
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								flamey = 0;
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), flamedy, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);

								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "heart_gut"+(1+Math.floor(2*Math.random())), 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "heart_gut"+(1+Math.floor(2*Math.random())), 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "heart_gut"+(1+Math.floor(2*Math.random())), 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								SpawnGuts(dsi,entities[dsi].x,entities[dsi].y,entities[dsi].vx-1+2*Math.random(),-7+2*Math.random(), "heart_gut"+(1+Math.floor(2*Math.random())), 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
							}
						
						}
		
						SpawnHead(dsi, entities[dsi].x,entities[dsi].y,entities[dsi].vx-4+8*Math.random(),entities[dsi].vy-8+4*Math.random(), 0);
	
	
						if (entities[dsi].hp3 > 0 && entity_misc[entities[dsi].type].damage == 1)
							entities[dsi].dir2 = "die2";
						else if (entity_misc[entities[dsi].type].damage == 3)
							entities[dsi].dir2 = "die2";
						else
							entities[dsi].dir2 = "legdie2";

						if (entities[dsi].type == 8 || entities[dsi].type == 9|| entities[dsi].type == 12)
							entities[dsi].dir2 = "die2";

						entities[dsi].frame2 = 0;
						
						if (entities[dsi].type == 4)
						{
							//wipe dead
							entities[dsi].dir1 = "die1"; 
							entities[dsi].frame1 = 0; 
						}	
					}
				
					else if (entities[dsi].type == 1 || entities[dsi].type == 3)
					{
						vx = entities[dsi].x-x;
						vy = entities[dsi].y-y;
						if (vx == 0 && vy == 0)
							vy = -1;
					
						if (entities[dsi].hp < entities[dsi].maxhp/2||1==1)
						{
							if (y < entities[dsi].y-6)
							{
								//go for a arm removal
								if (entities[dsi].hp1 > 0)
								{
									entities[dsi].hp1 = 0;
									var tsx,tsy;
									var randy= Math.random();
									var tlength = Math.sqrt(vx*vx+vy*vy);
									
									tsx = 3*Math.log(damage+3*randy+1)/Math.LN10*vx/tlength;
									tsy = 3*Math.log(damage+3*randy+1)/Math.LN10*vy/tlength-5;
									SpawnArm(dsi, x,y,tsx,tsy, gut_layer, entities[dsi].mask);
								}
								else if (entities[dsi].hp2 > 0)
								{
									entities[dsi].hp2 = 0;
									var tsx,tsy;
									var randy= Math.random();
									var tlength = Math.sqrt(vx*vx+vy*vy);
									
									tsx = 3*Math.log(damage+3*randy+1)/Math.LN10*vx/tlength;
									tsy = 3*Math.log(damage+3*randy+1)/Math.LN10*vy/tlength-5;
									SpawnArm(dsi, x,y,tsx,tsy, gut_layer+1, entities[dsi].mask);
								}
			
							}
							else if (entities[dsi].hp3 > 0)
							{
								//go for a leg removal
								entities[dsi].hp3 = 0;
								
								var tsx,tsy;
								var randy= Math.random();
								var tlength = Math.sqrt(vx*vx+vy*vy);
								tsx = 3*Math.log(damage+3*randy+1)/Math.LN10*vx/tlength;
								tsy = 3*Math.log(damage+3*randy+1)/Math.LN10*vy/tlength-5;
							
								if (entities[dsi].type == 1)
								{
									SpawnGuts(dsi, entities[dsi].x,entities[dsi].y,tsx-1+2*Math.random(),tsy-1+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									SpawnGuts(dsi, entities[dsi].x,entities[dsi].y,tsx-1+2*Math.random(),tsy-1+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
								else if (entities[dsi].type == 3)
								{
									SpawnGuts(dsi, entities[dsi].x,entities[dsi].y,tsx-1+2*Math.random(),tsy-1+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
									SpawnGuts(dsi, entities[dsi].x,entities[dsi].y,tsx-1+2*Math.random(),tsy-1+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[dsi].mask);
								}
								//remove this arm;
								entities[dsi].dir2 = "legfall1";
								entities[dsi].frame2 = 0;

							}
						}
					}
					else if (entities[dsi].type == 8)
					{
						vx = entities[dsi].x-x;
						vy = entities[dsi].y-y;
						
						if (vx == 0 && vy == 0)
						{
							vy = -1-Math.random();
							vx = -1+2*Math.random();
						}
						if (entities[dsi].hp < entities[dsi].maxhp*2)
						{
							//go for a arm removal
							if (entities[dsi].hp2 > 0)
							{
								entities[dsi].hp2 = 0;
								var tsx,tsy;
								var randy= Math.random();
								var tlength = Math.sqrt(vx*vx+vy*vy);
									
								tsx = 3*Math.log(damage+3*randy+1)/Math.LN10*vx/tlength;
								tsy = 3*Math.log(damage+3*randy+1)/Math.LN10*vy/tlength-5;
								SpawnArm(dsi, x,y,tsx,tsy, gut_layer+1, entities[dsi].mask);
								if (entities[dsi].type == 8)
								{
									for (d=0;d<2;d++)
									{
										randy= Math.random();
										tsx = 3*Math.log(damage+3*randy+1)/Math.LN10*vx/tlength;
										tsy = 3*Math.log(damage+3*randy+1)/Math.LN10*vy/tlength-5;
										SpawnArm(dsi, x,y,tsx,tsy, gut_layer+1*(d%2), entities[dsi].mask);
									}
								}


							}
						}
					}
				}
			}
		}
		if (invs > -1)
			return;
			
		if (targetdsi != undefined)
			break;
	}


	var dvx;

	//now for doors
	for (dsi=0;dsi<max_doors;dsi++)
	{
		if (targetdsi != undefined)
			break;
		if (type == 2)
			break;
		if (doors[dsi].type == 4 && doors[dsi].active == false)
		{
		  lengthx = (doors[dsi].x-x);
		  lengthy = (doors[dsi].y-y);
			if (Math.sqrt(lengthx*lengthx + lengthy*lengthy) < blast_radius*scale)
			{
				doors[dsi].hp -= damage;
				if (doors[dsi].hp < 10 && doors[dsi].spriteset == "door4")
				{
					doors[dsi].dir = "closed1";
					doors[dsi].frame = 0;

					SetPersonIDDirection(doors[dsi].id1, doors[dsi].dir);
					SetPersonIDFrame(doors[dsi].id1, doors[dsi].frame);

				}
				if (doors[dsi].hp <=0)
				{
					doors[dsi].active = 1;
					doors[dsi].hp = 0;

					doors[dsi].dir = "closed1";
					doors[dsi].frame = 0;
	
					SetPersonIDDirection(doors[dsi].id1, doors[dsi].dir);
					SetPersonIDFrame(doors[dsi].id1, doors[dsi].frame);

					var tdx = Math.floor(doors[dsi].x/GetTileWidth());
					var tdy = Math.floor(doors[dsi].y/GetTileWidth());
					
					SetTile(tdx,tdy, 0, 0);
					SetTile(tdx,tdy+1, 0, 0);
					
					if (doors[dsi].x < x)
					  dvx = -3;
					else
					  dvx = 3;

					if (doors[dsi].spriteset == "door4")
					{
						PlaySound(46, true);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-3,doors[dsi].x,doors[dsi].y,-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
					}
					else
					{
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,dvx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
						SpawnGuts(-2,doors[dsi].x,doors[dsi].y,-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), doors[dsi].mask);
					}
				}
			}
		}
	}

	for (dsi=0;dsi<max_explosions;dsi++)
	{
	  if (exps[dsi].x == blood_dx || exps[dsi].frame == exp_max_frame)
	  {
			exps[dsi].x = x;
			exps[dsi].y = y;
			
			if (type == undefined)
				exps[dsi].type = 0;
			else
			{
				exps[dsi].type = type;
				exps[dsi].damage = damage;
			}

			if (vx == undefined)
				exps[dsi].vx = 0;
			else
				exps[dsi].vx = vx;

			if (vy == undefined)
				exps[dsi].vy = 0;
			else
				exps[dsi].vy = vy;

				
	
			exps[dsi].dir = "explode1";
			exps[dsi].frame = 0;
			exps[dsi].layer = gut_layer+1;
			if (g_supernaut_active > 0)
				exps[dsi].layer = g_supernaut_head_layer+1;

			exps[dsi].scale = scale;
	
			SetPersonIDX(exps[dsi].id1, exps[dsi].x-(exps[dsi].scale-1)*16);
			SetPersonIDY(exps[dsi].id1, exps[dsi].y-(exps[dsi].scale-1)*16);

			SetPersonIDFrame(exps[dsi].id1, exps[dsi].frame);
			SetPersonIDDirection(exps[dsi].id1, exps[dsi].dir);
			SetPersonIDLayer(exps[dsi].id1, exps[dsi].layer);
			SetPersonIDScaleFactor(exps[dsi].id1, exps[dsi].scale,exps[dsi].scale);
	    return;
	  }
	}

}

function UpdateExplosions()
{
	for (i=0;i<max_explosions;i++)
	{
	  if (exps[i].x > blood_dx)
	  {
			if (exps[i].type == 2)
			{
				exps[i].x+=exps[i].vx;
				exps[i].y+=exps[i].vy;
				///....
				//FlipScreen();
				if (Math.abs(entities[0].x - exps[i].x) < entity_misc[8].atkw && Math.abs(entities[0].y - exps[i].y) < entity_misc[8].atkh)
				{
					FlameHurtPlayer(exps[i].damage);
				}
			}
			else if (exps[i].type == 3)
			{
				exps[i].x+=exps[i].vx;
				exps[i].y+=exps[i].vy;
				///....
				//FlipScreen();
				if (Math.abs(entities[0].x - exps[i].x) < exps[i].scale*16+16 && Math.abs(entities[0].y - exps[i].y) < exps[i].scale*16+12)
				{
					FlameHurtPlayer(exps[i].damage);
				}
			}

			if (exps[i].type == 3)
			{
				if (g_frames%(2*g_exp_update) == 0)
				{
					exps[i].frame++;
					
					if (exps[i].frame >= exp_max_frame)
					{
						exps[i].x = -100;
					}
				}
			}
			else if ((g_frames%g_exp_update == 0 && exps[i].type != 3) || g_frames%(3*g_exp_update) == 0)
			{
				exps[i].frame++;
				
				if (exps[i].frame >= exp_max_frame)
				{
					exps[i].x = -100;
				}
			}
	
			SetPersonIDX(exps[i].id1, exps[i].x-(exps[i].scale-1)*16);
			SetPersonIDY(exps[i].id1, exps[i].y-(exps[i].scale-1)*16);

			SetPersonIDFrame(exps[i].id1, exps[i].frame);
			SetPersonIDDirection(exps[i].id1, exps[i].dir);
			SetPersonIDLayer(exps[i].id1, exps[i].layer);
			SetPersonIDScaleFactor(exps[i].id1, exps[i].scale,exps[i].scale);
		}
	}
}



var grenade_time = 200;
var grenade_radius = 8;
var max_grenades = 60;
var grenades = new Array(max_grenades);

function SetupGrenades()
{
  for (i=0;i<max_grenades;i++)
  {
		grenades[i] = new Object();
		grenades[i].x = -100;
		grenades[i].y = 0;
		
		grenades[i].frame = 0;
		grenades[i].dir = "grenade1";
		grenades[i].name = "grenades"+i;
		grenades[i].id1 = GetPersonID("grenades"+i);
		grenades[i].layer = gut_layer+1;
		grenades[i].damage = 3;
  }
}


function SpawnGrenade(x,y, vx,vy, damage, type, owner, scale)
{
	for (sg=0;sg<max_grenades;sg++)
	{
	  if (grenades[sg].x == blood_dx)
	  {
			grenades[sg].x = x;
			grenades[sg].y = y;
			grenades[sg].vx = vx;
			grenades[sg].vy = vy;
			
			grenades[sg].owner = owner;
			grenades[sg].damage = damage;
			grenades[sg].type = type;
			grenades[sg].angle = 0;

			grenades[sg].timer = grenade_time;
			
			grenades[sg].dir = "grenade"+type;

			if (type == 4)
			{
			  grenades[sg].y-=8;
				grenades[sg].type = 3;
			}

			grenades[sg].layer = gut_layer+1;
			if (g_supernaut_active > 0)
				grenades[sg].layer = g_supernaut_head_layer+1;
			
			if (type == 3)
			{
			  grenades[sg].y-=8;
			  grenades[sg].scale=2;
			}
			else if (type == 2)
			  grenades[sg].scale=1.5;
			else if (type == 1)
			  grenades[sg].scale=1.5;
			  
			if (scale != undefined)
			  grenades[sg].scale = scale;

			if (type != 1)
				grenades[sg].angle=Math.atan2(grenades[sg].vy, grenades[sg].vx);
	
			SetPersonIDX(grenades[sg].id1, -100);
			SetPersonIDY(grenades[sg].id1, y);
			SetPersonIDDirection(grenades[sg].id1, grenades[sg].dir);
			SetPersonIDLayer(grenades[sg].id1, grenades[sg].layer);
	    return;
	  }
	}

}

var grenade_trigger_height = 4;
var grenade_trigger_width = 4;

function UpdateGrenades()
{
  var sx, sy;
  var gravity_const = 0.5;
  var max_fall = 7;
  var speed = 10;
  var friction = 0.55;
  var spp = 0;

  var gx,gy;
  var hx, hy;

	var lengthx, lengthy;

	var nauty = naut1;
	if (g_supernaut_active > 0)
	{
		nauty = ReturnActiveSupernaut();
	}
	
	var superflag = false;

	for (ui=0;ui<max_grenades;ui++)
	{
		superflag = false;
	  if (grenades[ui].x != blood_dx)
	  {
	    SetPersonIDLayer(grenades[ui].id1, 0);
			if (grenades[ui].type != 3 && grenades[ui].vy < max_fall && !IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x, grenades[ui].y+1))
				grenades[ui].vy+=gravity_const;

			
			if (IsXYInWater(grenades[ui].x,grenades[ui].y))// && grenades[ui].type != 3)
			{
				if (grenades[ui].vy > 1)
				{
					grenades[ui].vy-=1;
				}
				if (grenades[ui].vy <-1)
				{
					grenades[ui].vy+=1;
				}
				if (grenades[ui].vx > 1)
				{
					grenades[ui].vx-=1;
				}
				if (grenades[ui].vx <-1)
				{
					grenades[ui].vx+=1;
				}
			}
			else if (grenades[ui].type == 3)
			{
				spp = Math.sqrt(grenades[ui].vx*grenades[ui].vx + grenades[ui].vy*grenades[ui].vy);
				if (spp < 8-1)
				{
					if (spp > 0)
					{
						grenades[ui].vx = grenades[ui].vx*(8/spp);
						grenades[ui].vy = grenades[ui].vy*(8/spp);
					}
				}
			}
			
			grenades[ui].x+=grenades[ui].vx;
			grenades[ui].y+=grenades[ui].vy;
			
			gx=grenades[ui].x;
			gy=grenades[ui].y;
			
			if (IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x, grenades[ui].y))
			{
				if (grenades[ui].type > 1 && grenades[ui].type != 5)
				{
					SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
					grenades[ui].x = blood_dx;
					break;
				}
				else
				{
					
					for (uj=0;uj<speed;uj++)
					{
						grenades[ui].x -=grenades[ui].vx/speed;
						grenades[ui].y -=grenades[ui].vy/speed;
						if (!IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x, grenades[ui].y))
							break;
					}
	
	
					sx = grenades[ui].vx;
					sy = grenades[ui].vy;
	
	
					if (IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x, grenades[ui].y+1))
						grenades[ui].vy*=-0.8;
					if (IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x+1, grenades[ui].y))
						grenades[ui].vx*=-0.8;
	
					if (IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x, grenades[ui].y-1))
						grenades[ui].vy*=-0.8;
					if (IsPersonIDObstructed(grenades[ui].id1, grenades[ui].x-1, grenades[ui].y))
						grenades[ui].vx*=-0.8;
						
					if (sx != grenades[ui].vx)
					{
						if (Math.abs(sx) > 1)
						{
							if (grenades[ui].type != 5)
								PlaySound(35);
							else
								PlaySound(34);
						}
						//make sound here
					}
					if (sy != grenades[ui].vy)
					{
						if (Math.abs(sy) > 1)
						{
							if (grenades[ui].type != 5)
								PlaySound(35);
							else
								PlaySound(34);
						}
						//make sound here
					}
					
					if (sx== grenades[ui].vx && sy == grenades[ui].vy)
					{
						//make sound here
						grenades[ui].vx*=-0.8;
						PlaySound(34);
					}
		
					if (Math.abs(grenades[ui].vy)<1.5)
						grenades[ui].vy = 0;
				}
			}
			if (g_supernaut_active > 0 && grenades[ui].owner != -10)
			{
				hx = grenades[ui].x;
				hy = grenades[ui].y;
				//check if the grenade intersected the supernaut
				if (hx-nauty.x-nauty.hx > 0 && hx-nauty.x-nauty.hx < nauty.width-1 && 
						hy-nauty.y-nauty.hy > 0 && hy-nauty.y-nauty.hy < nauty.height-1)
				{
					//check a more precise hit...
					if (naut_head.getPixel(hx-nauty.x-nauty.hx, hy-nauty.y-nauty.hy).alpha > 0 && nauty.hp1 > 0)
					{
						tempcolor = naut_head_mask.getPixel(hx-nauty.x-nauty.hx, hy-nauty.y-nauty.hy);
						DoSupernautDamage(grenades[ui].damage, "head", tempcolor);
						//it's a hit;
						superflag = true;
					} 
				}
				if (hx-nauty.x-nauty.nx > 0 && hx-nauty.x-nauty.nx < nauty.width-1 && 
						hy-nauty.y-nauty.ny > 0 && hy-nauty.y-nauty.ny < nauty.height-1 && g_supernaut_active != 2)
				{
					if (superflag == false && naut_neck_bottom.getPixel(hx-nauty.x-nauty.nx, hy-nauty.y-nauty.ny).alpha > 0 && nauty.hp2 > 0)
					{
						tempcolor = naut_neck_bottom_mask.getPixel(hx-nauty.x-nauty.nx, hy-nauty.y-nauty.ny);
						DoSupernautDamage(grenades[ui].damage, "neck", tempcolor);
						//it's a hit;
						superflag = true;
					} 
				}
				if (hx-nauty.x-nauty.mx > 0 && hx-nauty.x-nauty.mx < nauty.width-1 && 
						hy-nauty.y-nauty.my > 0 && hy-nauty.y-nauty.my < nauty.height-1)
				{
					if (superflag == false && nauty.openmouth == 0)
					{
						if (naut_mouth_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).alpha > 0 && nauty.hp3 > 0)
						{
							if (naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).red > 0 ||
							naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).green > 0 ||
							naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).blue > 0)
							{
								tempcolor = naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my);
								DoSupernautDamage(grenades[ui].damage, "mouth_1", tempcolor);
								//it's a hit;
								superflag = true;
							}
						} 					
					}
					if (superflag == false && nauty.openmouth == 1)
					{
						if (naut_mouth_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).alpha > 0 && nauty.hp3 > 0)
						{
							if (naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).red > 0 ||
							naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).green > 0 ||
							naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).blue > 0)
							{
								tempcolor = naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my);
								DoSupernautDamage(grenades[ui].damage, "mouth_2", tempcolor);
								//it's a hit;
								superflag = true;
							}
						} 					
					}
					if (superflag == true)
					{
						SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
						grenades[ui].x = blood_dx;
						break;
					}
				}
			}
		
			if (grenades[ui].type == 1 || grenades[ui].type == 5)
			{
				if (grenades[ui].vx < 0 && IsGrenadeOnGround(ui))
				{
					grenades[ui].vx+=friction/4;
					if (grenades[ui].vx > 0)
						grenades[ui].vx = 0;
				}
				else if (grenades[ui].vx > 0 && IsGrenadeOnGround(ui))
				{
					grenades[ui].vx-=friction/4;
					if (grenades[ui].vx < 0)
						grenades[ui].vx = 0;
				}
			}
			
			if (grenades[ui].type == 1 || grenades[ui].type == 5)
				grenades[ui].angle+=grenades[ui].vx*0.04;
			else
				grenades[ui].angle=Math.atan2(grenades[ui].vy, grenades[ui].vx);

			//check for enemy explosions
			if (grenades[ui].owner != -10)
			{
				for (ssi=0;ssi<max_entities;ssi++)
				{
					if (entities[ssi].hp>0&& entities[ssi].ambush == false && entities[ssi].nohit != true)
					{
						lengthx = (entities[ssi].x-grenades[ui].x);
						lengthy = (entities[ssi].y-grenades[ui].y);
						if (Math.abs(lengthx) < entities[ssi].w+grenade_trigger_width &&Math.abs(lengthy) < entities[ssi].h +grenade_trigger_height&& ssi != grenades[ui].owner)
						{
							SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
							grenades[ui].x = blood_dx;
							break;
						}
					}
				}
		
				if (ssi>=max_entities)
				{
					grenades[ui].timer--
				
					if (grenades[ui].timer <=0)
					{
						SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
						grenades[ui].x = blood_dx;
					}
				}
			}
			else
			{
				lengthx = (entities[0].x-grenades[ui].x);
				lengthy = (entities[0].y-grenades[ui].y);
				if (Math.abs(lengthx) < 8+grenade_trigger_width &&Math.abs(lengthy) < 6+grenade_trigger_height)
				{
					SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
					grenades[ui].x = blood_dx;
				}
				else
				{
					grenades[ui].timer-=2;
				
					if (grenades[ui].timer <=0)
					{
						SpawnExplosion(grenades[ui].x,grenades[ui].y, grenades[ui].damage, grenades[ui].owner, grenades[ui].scale);
						grenades[ui].x = blood_dx;
					}
				}
			}
			
			SetPersonIDX(grenades[ui].id1, grenades[ui].x);
			SetPersonIDY(grenades[ui].id1, grenades[ui].y+2);
			SetPersonIDAngle(grenades[ui].id1, grenades[ui].angle);

			if (grenades[ui].x > GetLayerWidth(grenades[ui].layer)*GetTileWidth()+GetTileWidth()  ||
				  grenades[ui].x < -GetTileWidth() ||
				  grenades[ui].y > GetLayerHeight(grenades[ui].layer)*GetTileHeight()+GetTileHeight())
			{
			  grenades[ui].x = blood_dx;
			}
			
			
    SetPersonIDLayer(grenades[ui].id1, grenades[ui].layer);
	  }
		else
		{
			SetPersonIDX(grenades[ui].id1, blood_dx);
		}
	}
}



function IsGrenadeOnGround(num)
{
	if (IsPersonIDObstructed(grenades[num].id1, grenades[num].x, grenades[num].y+1) && Math.abs(grenades[num].vy) < 1.5)
		return true;
	return false;
}






var max_shrapnel = 20;
var shrapnel_damage = 15;
var shrap_spawn_number = 4;

var shrapnel = new Array(max_shrapnel);
for (i=0;i<max_shrapnel;i++)
{
  shrapnel[i] = new Object();
  shrapnel[i].x = -100;
  shrapnel[i].y = 0;
  shrapnel[i].vx = 0;
  shrapnel[i].vy = 0;

  shrapnel[i].name = "";
  shrapnel[i].id1 = 0;
  
  shrapnel[i].frame = 0;
  shrapnel[i].dir = 0;
  shrapnel[i].timer = 0;
  shrapnel[i].int_speed = 1;
  shrapnel[i].owner = 0;
}

var shrapnel_time = 200;

function SpawnShrapnel(x,y,vx,vy,owner)
{
	for (ssi=0;ssi<max_shrapnel;ssi++)
	{
		if (shrapnel[ssi].x == blood_dx)
		  break;
	}
	if (ssi<max_shrapnel)
	{
		shrapnel[ssi].x = x;
		shrapnel[ssi].y = y;

	  shrapnel[ssi].int_speed = Math.sqrt(vx*vx+vy*vy);


		shrapnel[ssi].layer = blood_layer;
		if (g_supernaut_active > 0)
			shrapnel[ssi].layer = g_supernaut_head_layer+1;

		
		SetPersonIDLayer(shrapnel[ssi].id1, 0);
		
		if (IsPersonIDObstructed(shrapnel[ssi].id1, x,y))
		{
			shrapnel[ssi].x = entities[owner].x;
		}
		
		
		shrapnel[ssi].vx = vx;
		shrapnel[ssi].vy = vy;

		shrapnel[ssi].frame = 0;
		shrapnel[ssi].dir = "shrapnel"+(1+Math.floor(Math.random()*4));
		shrapnel[ssi].owner = owner;
		shrapnel[ssi].timer = shrapnel_time;
		shrapnel[ssi].damage = shrapnel_damage;
		
		SetPersonIDLayer(shrapnel[ssi].id1, shrapnel[ssi].layer);
		SetPersonIDDirection(shrapnel[ssi].id1, shrapnel[ssi].dir);
		SetPersonIDFrame(shrapnel[ssi].id1, shrapnel[ssi].frame);
	}
}

function SetupShrapnel()
{
	for (ssi=0;ssi<max_shrapnel;ssi++)
	{
		shrapnel[ssi].x = blood_dx;
		shrapnel[ssi].y = 0;
		shrapnel[ssi].vx = 0;
		shrapnel[ssi].vy = 0;

		shrapnel[ssi].frame = 0;
		shrapnel[ssi].dir = "shrapnel1";
		shrapnel[ssi].owner = 0;
		shrapnel[ssi].damage = 4;
		shrapnel[ssi].timer = 200;

		shrapnel[ssi].name = "shrapnel"+ssi;
		shrapnel[ssi].id1 = GetPersonID("shrapnel"+ssi);
		shrapnel[ssi].layer = blood_layer;
	}
}










function UpdateShrapnel(change)
{
  var sx, sy;
  var gravity_const = 0.5;
  var max_fall = 7;
  var speed = 10;
  var bounce = 0.5;
  var friction = 0.25;
  var tspeed;
  var superflag = false

  var gx,gy;
  var loop;
  var hx,hy;

	var lengthx, lengthy;
	
	var sslow = 8;

	for (ui=0;ui<max_shrapnel;ui++)
	{

			if (shrapnel[ui].x != blood_dx)
			{
				
				if (IsXYInWater(shrapnel[ui].x,shrapnel[ui].y))
				{
				  tspeed = Math.sqrt(shrapnel[ui].vx*shrapnel[ui].vx+shrapnel[ui].vy*shrapnel[ui].vy);
				  if (tspeed > 2)
				  {
						shrapnel[ui].vx = shrapnel[ui].vx*(tspeed-1.5)/tspeed;
						shrapnel[ui].vy = shrapnel[ui].vy*(tspeed-1.5)/tspeed;
					}
				}		
				
				for (loop = 0;loop<3;loop++)
				{
					SetPersonIDLayer(shrapnel[ui].id1, 0);
					if (shrapnel[ui].vy < max_fall && !IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x, shrapnel[ui].y+1))
						shrapnel[ui].vy+=gravity_const/8;
					shrapnel[ui].x+=shrapnel[ui].vx;
					shrapnel[ui].y+=shrapnel[ui].vy;
					
					gx=shrapnel[ui].x;
					gy=shrapnel[ui].y;
					
					if (IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x, shrapnel[ui].y))
					{
						for (uj=0;uj<speed;uj++)
						{
							shrapnel[ui].x -=shrapnel[ui].vx/speed;
							shrapnel[ui].y -=shrapnel[ui].vy/speed;
							if (!IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x, shrapnel[ui].y))
								break;
						}
			
						sx = shrapnel[ui].vx*3;
						sy = shrapnel[ui].vy*3;
			
			
						if (IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x, shrapnel[ui].y+1))
							shrapnel[ui].vy*=-bounce;
						if (IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x+1, shrapnel[ui].y))
							shrapnel[ui].vx*=-bounce;
			
			
						if (IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x, shrapnel[ui].y-1))
							shrapnel[ui].vy*=-bounce;
						if (IsPersonIDObstructed(shrapnel[ui].id1, shrapnel[ui].x-1, shrapnel[ui].y))
							shrapnel[ui].vx*=-bounce;
								
						if (sx != shrapnel[ui].vx)
						{
							PlaySound(88+Math.floor(3*Math.random()),true);
							//make sound here
						}
						if (sy != shrapnel[ui].vy)
						{
							PlaySound(88+Math.floor(3*Math.random()),true);
							//make sound here
						}
							
						if (sx== shrapnel[ui].vx && sy == shrapnel[ui].vy)
						{
							PlaySound(88+Math.floor(3*Math.random()),true);
							//make sound here
							shrapnel[ui].vx*=-bounce;
						}
				
						if (Math.abs(shrapnel[ui].vy)<1.5)
							shrapnel[ui].vy = 0;
					}
				
					if (shrapnel[ui].vx < 0 && IsShrapnelOnGround(ui))
					{
						shrapnel[ui].vx+=friction/4;
						if (shrapnel[ui].vx > 0)
							shrapnel[ui].vx = 0;
					}
					else if (shrapnel[ui].vx > 0 && IsShrapnelOnGround(ui))
					{
						shrapnel[ui].vx-=friction/4;
						if (shrapnel[ui].vx < 0)
							shrapnel[ui].vx = 0;
					}
					
					
				}
	/*		
				if (shrapnel[ui].type == 1)
					shrapnel[ui].angle+=shrapnel[ui].vx*0.04;
				else
					shrapnel[ui].angle=Math.atan2(shrapnel[ui].vy, shrapnel[ui].vx);
	*/
	
				//check for enemy hits
				for (ssi=0;ssi<max_entities;ssi++)
				{
					//break;
					if (entities[ssi].hp>0&& entities[ssi].ambush == false && entities[ssi].active == true&& entities[ssi].nohit != true)
					{
						if (entities[ssi].hp3 > 0)
						{
							lengthx = (entities[ssi].x-shrapnel[ui].x);
							lengthy = (entities[ssi].y-shrapnel[ui].y);
						}
						else
						{
							lengthx = (entities[ssi].x-shrapnel[ui].x);
							lengthy = (entities[ssi].y+entities[ssi].h/2-shrapnel[ui].y);
						}
					
						if (Math.abs(lengthx) < entities[ssi].w+4+2*Math.abs(shrapnel[ui].vx) &&((Math.abs(lengthy) < entities[ssi].h+4+2*Math.abs(shrapnel[ui].vy) && entities[ssi].hp3 > 0) || (entities[ssi].hp3<=0 && Math.abs(lengthy) < entities[ssi].h/2+2))&& ssi != shrapnel[ui].owner)
						{
							tspeed = Math.sqrt(shrapnel.vx*shrapnel.vx*9+shrapnel.vy*shrapnel.vy*9);
							//hit the enemy
							
							if (shrapnel[ui].int_speed > 1);
							else
								shrapnel[ui].int_speed = 1;

							SpawnExplosion(shrapnel[ui].x,shrapnel[ui].y, shrapnel[ui].damage*0.5, 0, 0.5, undefined,shrapnel[ui].vx/sslow,shrapnel[ui].vy/sslow, undefined, ssi);

							var tx = shrapnel[ui].vx*3;
							var ty = shrapnel[ui].vy*3;
/*	
							if (entities[ssi].hp<=0)
							{
								entities[ssi].hp = 0;
								
								var hsx,hsy;
								var hrandy= Math.random();
								var hlength = Math.sqrt(tx*tx+ty*ty);
								hsx = 3*Math.log(shrapnel[ui].damage+3*hrandy+1)/Math.LN10*tx/hlength;
								hsy = 3*Math.log(shrapnel[ui].damage+3*hrandy+1)/Math.LN10*ty/hlength-5;
								
								
								if (shrapnel[ui].damage >= 5 && shrapnel[ui].damage <10)
									SpawnHead(ssi,entities[ssi].x,entities[ssi].y, hsx,hsy, Math.floor((Math.random()*10+shrapnel[ui].damage)/10));//Math.sqrt(Math.random()*2)));
								else if (shrapnel[ui].damage >=10)
									SpawnHead(ssi,entities[ssi].x,entities[ssi].y, hsx,hsy, 1);
								else 
									SpawnHead(ssi,entities[ssi].x,entities[ssi].y, hsx,hsy, 0);
								
							}
*/	
							if (entity_misc[entities[ssi].type].blood == 1)
							{
								SpawnBloodSplat(entities[ssi].x,entities[ssi].y,tx,ty, 2.9);						  
	
								//spawn other blood
							}
	
							shrapnel[ui].x = blood_dx;
							break;
						}
					}
				}
		
	
	
	
	
	
				superflag = false;
	
				if (g_supernaut_active > 0)
				{
					var nauty = ReturnActiveSupernaut();
					hx = shrapnel[ui].x;
					hy = shrapnel[ui].y;
					//check if the grenade intersected the supernaut
					if (hx-nauty.x-nauty.hx > 0 && hx-nauty.x-nauty.hx < nauty.width-1 && 
							hy-nauty.y-nauty.hy > 0 && hy-nauty.y-nauty.hy < nauty.height-1)
					{
						//check a more precise hit...
						if (naut_head.getPixel(hx-nauty.x-nauty.hx, hy-nauty.y-nauty.hy).alpha > 0 && nauty.hp1 > 0)
						{
							tempcolor = naut_head_mask.getPixel(hx-nauty.x-nauty.hx, hy-nauty.y-nauty.hy);
							DoSupernautDamage(shrapnel[ui].damage, "head", tempcolor);
							//it's a hit;
							superflag = true;
						} 
					}
					if (hx-nauty.x-nauty.nx > 0 && hx-nauty.x-nauty.nx < nauty.width-1 && 
							hy-nauty.y-nauty.ny > 0 && hy-nauty.y-nauty.ny < nauty.height-1 && g_supernaut_active != 2)
					{
						if (superflag == false && naut_neck_bottom.getPixel(hx-nauty.x-nauty.nx, hy-nauty.y-nauty.ny).alpha > 0 && nauty.hp2 > 0)
						{
							tempcolor = naut_neck_bottom_mask.getPixel(hx-nauty.x-nauty.nx, hy-nauty.y-nauty.ny);
							DoSupernautDamage(shrapnel[ui].damage, "neck", tempcolor);
							//it's a hit;
							superflag = true;
						} 
					}
					if (hx-nauty.x-nauty.mx > 0 && hx-nauty.x-nauty.mx < nauty.width-1 && 
							hy-nauty.y-nauty.my > 0 && hy-nauty.y-nauty.my < nauty.height-1)
					{
						if (superflag == false && nauty.openmouth == 0)
						{
							if (naut_mouth_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).alpha > 0 && nauty.hp3 > 0)
							{
								if (naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).red > 0 ||
								naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).green > 0 ||
								naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).blue > 0)
								{
									tempcolor = naut_mouth_mask_1.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my);
									DoSupernautDamage(shrapnel[ui].damage, "mouth_1", tempcolor);
									//it's a hit;
									superflag = true;
								}
							} 					
						}
						if (superflag == false && nauty.openmouth == 1)
						{
							if (naut_mouth_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).alpha > 0 && nauty.hp3 > 0)
							{
								if (naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).red > 0 ||
								naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).green > 0 ||
								naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my).blue > 0)
								{
									tempcolor = naut_mouth_mask_2.getPixel(hx-nauty.x-nauty.mx, hy-nauty.y-nauty.my);
									DoSupernautDamage(shrapnel[ui].damage, "mouth_2", tempcolor);
									//it's a hit;
									superflag = true;
								}
							} 					
						}
					}
				
				
					if (superflag == true)
					{
						shrapnel[ui].x = blood_dx;
						SpawnBloodSplat(hx,hy,4*Math.random()-1,-4-2*Math.random(), shrapnel[ui].damage);
						//break;
					}

				}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
			
				if (1==1)
				{
					shrapnel[ui].timer-=4;
					tspeed = Math.sqrt(shrapnel[ui].vx*shrapnel[ui].vx+shrapnel[ui].vy*shrapnel[ui].vy);
					if (shrapnel[ui].timer <=0 || tspeed <0.1)
					{
					//get rid of the shrapnel
						SpawnExplosion(shrapnel[ui].x,shrapnel[ui].y, shrapnel[ui].damage*0.5/10, 0, 0.5, undefined,shrapnel[ui].vx/sslow,shrapnel[ui].vy/sslow, undefined);

						shrapnel[ui].x = blood_dx;
					}
				}
				
				shrapnel[ui].frame=(shrapnel[ui].frame+1)%2;

				
				SetPersonIDFrame(shrapnel[ui].id1, shrapnel[ui].frame);
				SetPersonIDX(shrapnel[ui].id1, shrapnel[ui].x);
				SetPersonIDY(shrapnel[ui].id1, shrapnel[ui].y+2);
	//			SetPersonIDAngle(shrapnel[ui].id1, shrapnel[ui].angle);
	
				if (shrapnel[ui].x > GetLayerWidth(shrapnel[ui].layer)*GetTileWidth()+GetTileWidth()  ||
						shrapnel[ui].x < -GetTileWidth() ||
						shrapnel[ui].y > GetLayerHeight(shrapnel[ui].layer)*GetTileHeight()+GetTileHeight())
				{
					shrapnel[ui].x = blood_dx;
				}
				
			SetPersonIDLayer(shrapnel[ui].id1, shrapnel[ui].layer);
			}
	}


}



function IsShrapnelOnGround(num)
{
	if (IsPersonIDObstructed(shrapnel[num].id1, shrapnel[num].x, shrapnel[num].y+1) && Math.abs(shrapnel[num].vy) < 1.5)
		return true;
	return false;
}


var oblit_x = 200;
var oblit_y = 160;

var oblit_max = 50;
var oblit_frame = 0;

function FireObliterator(num)
{
	if (num == 0)
	{
		//normal attack
		oblit_frame = oblit_max;

	}
	else
	{
		//shield 
		oblit_shield = oblit_shield_length;
	}
}


function ApplyObliterator()
{
	  for (fi=1;fi<max_entities;fi++)
	  {
			if (Math.abs(entities[0].x-entities[fi].x) < oblit_x && Math.abs(entities[0].y-entities[fi].y) < oblit_y && entities[fi].hp > 0&& entities[fi].ambush == false && entities[fi].nohit != true)
			{
				if (entities[fi].type == 6)
				{
					entities[fi]["hp"+entities[fi].farm] -= ammo_array[9].damage;

					if (entities[fi]["hp"+entities[fi].farm] <= 0)
					{
						var tsx,tsy;
						var randy= Math.random();
						tsx = -(2+3*randy)*entities[fi].dir;
						tsy = -(4+2*randy);
						SpawnArm(fi, entities[fi].x,entities[fi].x,tsx,tsy, gut_layer+1*((entities[fi].farm+1)%2), entities[fi].mask);
	
						randy = Math.random();
						tsx = -(2+3*randy)*entities[fi].dir;
						tsy = -(4+2*randy);
						SpawnArm(fi, entities[fi].x,entities[fi].x,tsx,tsy, gut_layer+1*((entities[fi].farm+1)%2), entities[fi].mask);
					
						if (id_walk_back >= 7 && id_stage == 3 && entities[fi].dir2 != "die1")
						{
							entities[fi].dir2 = "die1";
							entities[fi].vx = 0;
							entities[fi].frame2 = 0;
							id_death_counter = 0;
						}
						else if (entities[fi].dir2 != "armregen" && entities[fi].dir2 != "die1")
						{
							entities[fi].dir2 = "armregen";
							entities[fi].vx = 0;
							entities[fi].frame2 = 0;
						}
						if (id_regencount < 0)
							id_regencount = 0;
			
						SetPersonIDDirection(entities[fi].id1, "idle"+"east");
						SetPersonIDDirection(entities[fi].id2, "idle"+"east");
			
						SetPersonIDFrame(entities[fi].id1, id_regencount);
						SetPersonIDFrame(entities[fi].id2, id_regencount);


						SetPersonIDX(entities[fi].id2, -100);
					}
				}
				else
				{
					
					entities[fi].hp -= ammo_array[9].damage;
	
					if (entity_misc[entities[fi].type].blood == 1)
					{
						SpawnBlood(entities[fi].x,entities[fi].y,Math.random()*4-2,-7-3*Math.random(),1, "w", 0);
						SpawnBlood(entities[fi].x,entities[fi].y,Math.random()*4-2,-7-3*Math.random(),1, "w", 0);
						SpawnBlood(entities[fi].x,entities[fi].y,Math.random()*4-2,-7-3*Math.random(),1, "w", 0);
						AddScore(1);
					}
			
					if (entities[fi].hp <=0)
					{
						if (entity_misc[entities[fi].type].blood == 1)
						{
							AddScore(1);
							SpawnBlood(entities[fi].x,entities[fi].y,Math.random()*4-2,-5-3*Math.random(),1, "w", 0);
							SpawnBlood(entities[fi].x,entities[fi].y,Math.random()*4-2,-5-3*Math.random(),1, "w", 0);
							
							AddBackBlood(Math.floor(entities[fi].x/GetTileWidth()),Math.floor(entities[fi].y/GetTileHeight()),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[fi].x/GetTileWidth()),Math.floor(entities[fi].y/GetTileHeight()+1),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[fi].x/GetTileWidth()),Math.floor(entities[fi].y/GetTileHeight()-1),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[fi].x/GetTileWidth()+1),Math.floor(entities[fi].y/GetTileHeight()),4);
							if (Math.random()<0.6)
								AddBackBlood(Math.floor(entities[fi].x/GetTileWidth()-1),Math.floor(entities[fi].y/GetTileHeight()),4);
						}
	
						SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
						SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
						SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
	
						if (entities[fi].type == 1)
						{
							SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp1 > 0)
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp2 > 0)
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp3 > 0)
							{
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
								if (Math.random() < 0.5)
									SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							}
						}
						else if (entities[fi].type == 3)
						{
							SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp1 > 0)
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp2 > 0)
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							if (entities[fi].hp3 > 0)
							{
								SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
								if (Math.random() < 0.5)
									SpawnGuts(fi,entities[fi].x,entities[fi].y,entities[fi].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[fi].mask);
							}
						}
	
						SpawnHead(fi, entities[fi].x,entities[fi].y,entities[fi].vx-4+8*Math.random(),entities[fi].vy-8+4*Math.random(), 1);
		
						entities[fi].hp = 0;
	
						if (entities[fi].hp3 > 0)
							entities[fi].dir2 = "die2";
						else if (entity_misc[entities[fi].type].damage == 3 ||entity_misc[entities[fi].type].damage == 0 )
							entities[fi].dir2 = "die2";
						else if (entity_misc[entities[fi].type].damage == 1 ||entity_misc[entities[fi].type].damage == 2 )
							entities[fi].dir2 = "legdie2";
							
						if (entities[fi].type == 6)
							entities[fi].dir2 = "die";
						entities[fi].frame2 = 0;
					}
				}
			}
	  }
	  var nauty;
	  if (g_supernaut_active > 0)
	  {
			//apply the obliterator to the supernaut...
	  }
}

function DrawObliterator()
{
	var angle;
	var radius1 = 200;
	var radius2 = 10;

	if (oblit_frame > 5)
	{
		for (dd=0;dd<3;dd++)
		{
			angle = Math.random()*4*3.14159;
			SpawnRailgun(radius2*Math.cos(angle)+entities[0].x, radius2*Math.sin(angle)+entities[0].y+10,
									 radius1*Math.cos(angle)+entities[0].x, radius1*Math.sin(angle)+entities[0].y+10,1);
			
//			GradientLine(entities[0].x, entities[0].y, ,CreateColor(0,0,0,0), CreateColor(railguns[0].cr,railguns[0].cg,railguns[0].cb));
		}
	}
	if (oblit_frame <25 && oblit_frame > 5)
	{
	  Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255, 255-255*(oblit_frame-5)/20));
	}	
	else if (oblit_frame == 5)
	{
	  Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255, 255));
	  ApplyObliterator();
	}
	else if (oblit_frame < 5)
	{
	  Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255, 255*(oblit_frame)/5));
	}
}



